# 🚀 BackChat Chrome Extension - Quick Start

Get up and running in 3 minutes!

## Step 1: Create Icons (1 minute)

Choose the easiest method for you:

### Option A: Python (Recommended)
```bash
cd chrome_extension
pip install pillow
python3 generate_icons.py
```

### Option B: ImageMagick
```bash
cd chrome_extension
./generate_icons.sh
```

### Option C: Online (No install needed)
1. Go to https://www.iloveimg.com/resize-image/resize-svg
2. Upload `icons/icon.svg`
3. Resize to 16x16, 48x48, and 128x128
4. Save as `icon16.png`, `icon48.png`, `icon128.png` in the `icons/` folder

## Step 2: Install Extension (30 seconds)

1. Open Chrome
2. Go to `chrome://extensions/`
3. Toggle "Developer mode" ON (top right)
4. Click "Load unpacked"
5. Select the `chrome_extension` folder
6. Done! ✅

## Step 3: Login (30 seconds)

1. Click the BackChat icon in your Chrome toolbar
2. Enter your phone number (format: +1234567890)
3. Click "Login"
4. You're in! 🎉

## Step 4: Make Your First Call (1 minute)

### Quick Call:
Just type a phone number and press Enter!
```
+447123456789
```

### Or Use Menu:
Type `menu` to see all options:
- **1** - Top up
- **2** - Set primary number
- **3** - Recent calls
- **4** - Check balance
- **5** - Check rates
- **6** - Export history
- **7** - Call again

## Common Commands

| Type | Action |
|------|--------|
| `+44...` | Call this number |
| `menu` | Show main menu |
| `balance` | Quick balance check |
| `again` | Repeat last call |
| `$10` | Top up $10 |

## Troubleshooting

### "Icons missing" error?
→ Complete Step 1 above

### Can't login?
→ Check phone format: must start with `+` (e.g., `+1234567890`)

### Not seeing balance?
→ Wait 5 seconds or type `4` to refresh

### Extension not appearing?
→ Check if Developer Mode is ON in chrome://extensions/

## Quick Tips

💡 **Tip 1**: Pin the extension to your toolbar for easy access
- Click the puzzle icon
- Find BackChat
- Click the pin

💡 **Tip 2**: Enable notifications
- Allow notifications when prompted
- Get instant call completion alerts

💡 **Tip 3**: Use keyboard shortcuts
- Press `Enter` to send messages
- No need to click the send button

## Need More Help?

📖 **Detailed Guides**:
- README.md - Complete feature overview
- INSTALLATION.md - Detailed installation guide
- FEATURES.md - All features explained

🆘 **Support**:
- Email: support@backchat.kurasika.tech
- Website: https://backchat.kurasika.tech

## That's It!

You're ready to make international calls from your browser! 🌍📞

**Happy Calling!** 🎉
