# BackChat Chrome Extension

A Chrome extension that brings BackChat's call management functionality directly to your browser.

## Features

- 🎯 **Quick Access**: Make international calls directly from your browser
- 💰 **Balance Management**: Check your balance and top up instantly
- 📞 **Call History**: View your recent calls and costs
- 🔐 **Secure**: OAuth-style authentication with your BackChat account
- 📱 **WhatsApp-like UI**: Familiar chat interface for easy interaction
- 🔔 **Notifications**: Get real-time updates on call status

## Installation

### Option 1: Load Unpacked Extension (Development)

1. Open Chrome and navigate to `chrome://extensions/`
2. Enable "Developer mode" in the top right
3. Click "Load unpacked"
4. Select the `chrome_extension` folder
5. The extension will appear in your toolbar

### Option 2: Install from Chrome Web Store (Coming Soon)

We're working on publishing to the Chrome Web Store for easier installation.

## Usage

### First Time Setup

1. Click the BackChat icon in your Chrome toolbar
2. Enter your WhatsApp number (the same one you use with BackChat)
3. Click "Login" to authenticate

### Making a Call

1. Open the extension popup
2. Type a phone number (e.g., `+447123456789`)
3. Choose which number to call from (if you have a primary number set)
4. Answer your phone when it rings to connect to the destination

### Menu Options

Type the number or keyword:

- **1** - Top up your balance
- **2** - Set/change primary number
- **3** - View recent calls
- **4** - Check your balance
- **5** - Check call rates
- **6** - Export call history
- **7** - Call again (repeat last call)

Or simply type any phone number to start a call!

### Quick Commands

- Type `menu` - Return to main menu
- Type `balance` - Quick balance check
- Type `rate +1234567890` - Check rate for a number
- Type `again` - Repeat your last call

## Features in Detail

### Balance Top-up

1. Select option 1 or type an amount like `$10`, `$25`, etc.
2. You'll receive a payment link
3. Complete payment to add balance to your account

### Primary Number Setup

1. Select option 2
2. Enter your phone number
3. Verify with the OTP sent to your phone
4. Use this number for outgoing calls

### Call Status Updates

The extension automatically checks for call status updates every 5 seconds:
- ✅ **Completed calls**: See duration and cost
- ❌ **Failed calls**: Get retry suggestions
- 🔄 **In progress**: Real-time status updates

### Desktop Notifications

Enable notifications to receive:
- Call completion alerts
- Low balance warnings
- Payment confirmations

## Keyboard Shortcuts

- **Enter**: Send message / Select option
- **Escape**: Close extension popup

## Privacy & Security

- Your phone number and credentials are stored locally in Chrome's secure storage
- All communication with BackChat servers uses HTTPS encryption
- No third-party tracking or analytics

## Troubleshooting

### Extension not loading?

1. Make sure you're using Chrome version 88 or later
2. Check that developer mode is enabled
3. Try removing and re-adding the extension

### Can't login?

1. Verify your phone number format (must start with +)
2. Make sure you have an active BackChat account
3. Check your internet connection

### Not receiving updates?

1. Make sure notifications are enabled for Chrome
2. Check that the extension has permission to show notifications
3. Try closing and reopening the extension

## Support

For issues or questions:
- Email: support@backchat.kurasika.tech
- Website: https://backchat.kurasika.tech

## Version History

### v1.0.0 (Current)
- Initial release
- WhatsApp-like chat interface
- Full call management functionality
- Real-time status updates
- Desktop notifications

## Development

Built with:
- Manifest V3
- Vanilla JavaScript (no frameworks)
- Chrome Storage API
- Chrome Notifications API

## License

© 2024 BackChat. All rights reserved.
