// BackChat Chrome Extension - Background Service Worker

// Listen for extension installation
chrome.runtime.onInstalled.addListener((details) => {
    if (details.reason === 'install') {
        console.log('BackChat extension installed');
        // Open welcome page
        chrome.tabs.create({
            url: 'https://backchat.kurasika.tech'
        });
    }
});

// Listen for messages from popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.type === 'NOTIFICATION') {
        // Show notification
        chrome.notifications.create({
            type: 'basic',
            iconUrl: 'icons/icon128.png',
            title: request.title || 'BackChat',
            message: request.message,
            priority: 2
        });
    }
    
    if (request.type === 'OPEN_TAB') {
        // Open a new tab
        chrome.tabs.create({
            url: request.url
        });
    }
    
    return true;
});

// Keep service worker alive
let keepAlive = setInterval(() => {
    chrome.runtime.getPlatformInfo();
}, 20000);

// Clean up on shutdown
chrome.runtime.onSuspend.addListener(() => {
    clearInterval(keepAlive);
});
